<!DOCTYPE html>
<html lang="es">
<head><meta charset="utf-8"><title>Marcación Facial</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
<h3>Marcación Facial</h3>
<p>Instrucciones: descarga <code>face-api.min.js</code> y coloca en <code>assets/js/</code>, descarga los modelos y colócalos en <code>assets/models/</code>.</p>
<div>
  <label>Tipo de marca:</label>
  <select id="tipo" class="form-select" style="width:300px;">
    <option value="entrada">Entrada</option>
    <option value="salida">Salida</option>
    <option value="descanso_salida">Salida al descanso</option>
    <option value="descanso_entrada">Entrada del descanso</option>
  </select>
</div>
<video id="video" width="480" height="360" autoplay class="mt-2"></video>
<canvas id="canvas" style="display:none"></canvas>
<div class="mt-2"><button id="marcar" class="btn btn-success">Marcar</button></div>
<div id="mensaje" class="mt-2"></div>
</div>
<script src="../assets/js/face-api.min.js"></script>
<script>
// This page expects face-api.min.js and models to be present. The controller simulates backend matching if models are not present.
(async ()=>{
  try{ const s = await navigator.mediaDevices.getUserMedia({video:true}); document.getElementById('video').srcObject = s;}catch(e){document.getElementById('mensaje').innerText='No se pudo usar la cámara.'}
  document.getElementById('marcar').addEventListener('click', async ()=>{
    const canvas = document.getElementById('canvas'); const v = document.getElementById('video');
    canvas.width=v.videoWidth; canvas.height=v.videoHeight; canvas.getContext('2d').drawImage(v,0,0);
    const foto = canvas.toDataURL('image/jpeg');
    const tipo = document.getElementById('tipo').value;
    const res = await fetch('../controllers/MarcaController.php?action=registrar_face',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({empleado:'Juan',foto:foto,tipo_marca:tipo})});
    const j = await res.json(); if(j.success) document.getElementById('mensaje').innerText='Marcación registrada.'; else document.getElementById('mensaje').innerText='Error: '+(j.msg||'');
  });
})();
</script>
</body>
</html>