<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>AsistFacial - Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.5/font/bootstrap-icons.min.css" rel="stylesheet">
<style>
:root{--bg:#f6f9fc;--card:#fff;--text:#111}
[data-theme='dark']{--bg:#0f1724;--card:#0b1220;--text:#e6eef8}
body{background:var(--bg);color:var(--text);font-family:Inter,Arial,Helvetica,sans-serif}
.center{min-height:100vh;display:flex;align-items:center;justify-content:center}
.card{background:var(--card);padding:24px;border-radius:12px;box-shadow:0 6px 18px rgba(2,6,23,0.08)}
.logo{display:flex;align-items:center;gap:12px}
.logo img{height:34px}
.switch{cursor:pointer}
</style>
</head>
<body>
<div class="center">
  <div class="card" style="width:380px">
    <div class="logo mb-3">
      <img src="../assets/icons/logo.svg" alt="logo" />
      <div><strong>AsistFacial</strong></div>
      <div style="margin-left:auto"><button id="themeBtn" class="btn btn-sm btn-outline-secondary">☀️</button></div>
    </div>
    <h5>Acceso administrador</h5>
    <?php if(isset($_GET['error'])) echo '<div class="alert alert-danger">Contraseña incorrecta</div>'; ?>
    <form method="post" action="../controllers/AuthController.php">
      <input name="password" type="password" class="form-control mb-2" placeholder="Contraseña" required />
      <button class="btn btn-primary w-100">Entrar</button>
    </form>
    <p class="mt-3 small text-muted">Zona horaria: <?php echo date_default_timezone_get(); ?></p>
  </div>
</div>
<script>
const tbtn = document.getElementById('themeBtn');
if(localStorage.getItem('theme')==='dark') document.documentElement.setAttribute('data-theme','dark');
function toggle(){ if(document.documentElement.getAttribute('data-theme')==='dark'){ document.documentElement.removeAttribute('data-theme'); localStorage.setItem('theme','light'); tbtn.textContent='☀️'; } else { document.documentElement.setAttribute('data-theme','dark'); localStorage.setItem('theme','dark'); tbtn.textContent='🌙'; } }
tbtn.addEventListener('click', toggle);
if(localStorage.getItem('theme')==='dark') tbtn.textContent='🌙';
</script>
</body>
</html>