<?php include __DIR__ . '/../includes/session.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8"><title>AsistFacial - Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.5/font/bootstrap-icons.min.css" rel="stylesheet">
<style>
:root{--bg:#f6f9fc;--card:#fff;--muted:#64748b}
[data-theme='dark']{--bg:#071127;--card:#081425;--muted:#9aa9bf}
body{background:var(--bg);color:var(--muted);font-family:Inter,Arial,Helvetica,sans-serif}
.header{display:flex;align-items:center;gap:12px;padding:18px}
.card{background:var(--card);border-radius:12px;padding:16px;color:var(--muted);box-shadow:0 6px 18px rgba(2,6,23,0.06)}
.kpi{display:flex;gap:12px}
.kpi .item{flex:1}
.tab-buttons{display:flex;gap:8px;margin-bottom:12px}
</style>
</head>
<body>
<div class="container-fluid p-4">
  <div class="header mb-3">
    <img src="../assets/icons/logo.svg" height="38" alt="logo"/>
    <h4 style="margin:0">AsistFacial</h4>
    <div style="margin-left:auto">👋 Bienvenido, Admin — <?php echo date('d M Y'); ?></div>
    <div style="margin-left:12px"><button id="themeBtn" class="btn btn-sm btn-outline-secondary">☀️</button></div>
  </div>
  <div class="kpi mb-3">
    <div class="item card">
      <h6>Horas hoy</h6><h3 id="horas">0</h3>
    </div>
    <div class="item card">
      <h6>Horas extras</h6><h3 id="extras">0</h3>
    </div>
    <div class="item card">
      <h6>Horas nocturnas</h6><h3 id="noct">0</h3>
    </div>
    <div class="item card">
      <h6>Llegadas tarde (min)</h6><h3 id="tardanzas">0</h3>
    </div>
  </div>
  <div class="card mb-3">
    <div class="tab-buttons">
      <button class="btn btn-primary" id="tabDaily"><i class="bi bi-calendar-day"></i> Diaria</button>
      <button class="btn btn-outline-secondary" id="tabWeek"><i class="bi bi-calendar-week"></i> Semanal</button>
      <button class="btn btn-outline-secondary" id="tabMonth"><i class="bi bi-calendar-month"></i> Mensual</button>
    </div>
    <canvas id="chartLate"></canvas>
  </div>
  <div class="card">
    <h5>Registros recientes</h5>
    <div id="recent">(Aquí aparecen las últimas marcas)</div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// theme
const tbtn = document.getElementById('themeBtn');
if(localStorage.getItem('theme')==='dark') document.documentElement.setAttribute('data-theme','dark');
function toggle(){ if(document.documentElement.getAttribute('data-theme')==='dark'){ document.documentElement.removeAttribute('data-theme'); localStorage.setItem('theme','light'); tbtn.textContent='☀️'; } else { document.documentElement.setAttribute('data-theme','dark'); localStorage.setItem('theme','dark'); tbtn.textContent='🌙'; } }
tbtn.addEventListener('click', toggle);
if(localStorage.getItem('theme')==='dark') tbtn.textContent='🌙';

// demo chart
const ctx = document.getElementById('chartLate').getContext('2d');
const chart = new Chart(ctx, { type:'bar', data: { labels:['Juan Pérez'], datasets:[{ label:'Llegadas tarde (veces)', data:[1] }] }, options:{ responsive:true } });
</script>
</body>
</html>