<?php
require_once __DIR__ . '/../includes/config.php';
class Marca {
    public static function create($data) {
        global $pdo;
        $stmt = $pdo->prepare("INSERT INTO marcas (empleado_id,tipo_marca,fecha_hora,reconocimiento_ok,foto_captura,foto_path) VALUES (?,?,?,?,?,?)");
        $stmt->execute([$data['empleado_id'],$data['tipo_marca'],$data['fecha_hora'],$data['reconocimiento_ok'],$data['foto_captura'],$data['foto_path'] ?? null]);
    }
    public static function getByEmpleado($id,$fi,$ff){
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM marcas WHERE empleado_id=? AND fecha_hora BETWEEN ? AND ? ORDER BY fecha_hora ASC");
        $stmt->execute([$id,$fi,$ff]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public static function getRecent($limit=20){
        global $pdo;
        $stmt = $pdo->query("SELECT m.*, e.nombre, e.apellido FROM marcas m JOIN empleados e ON e.id=m.empleado_id ORDER BY m.fecha_hora DESC LIMIT $limit");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>