<?php
require_once __DIR__ . '/../includes/config.php';
class Empleado {
    public static function getAll() {
        global $pdo;
        $stmt = $pdo->query("SELECT id,nombre,apellido,cargo,turno_actual FROM empleados");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public static function findById($id) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM empleados WHERE id=?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    public static function create($data) {
        global $pdo;
        $stmt = $pdo->prepare("INSERT INTO empleados (nombre,apellido,cedula,correo,cargo,turno_actual,foto_base) VALUES (?,?,?,?,?,?,?)");
        $stmt->execute([$data['nombre'],$data['apellido'],$data['cedula'],$data['correo'],$data['cargo'],$data['turno_actual'],$data['foto_base'] ?? null]);
    }
}
?>