<?php
require_once __DIR__ . '/../includes/session.php';
require_once __DIR__ . '/../models/Marca.php';
require_once __DIR__ . '/../models/Empleado.php';
require_once __DIR__ . '/../vendor/autoload.php';

if(!isset($_GET['empleado_id']) || !isset($_GET['mes']) || !isset($_GET['anio'])){ die('Parámetros faltantes'); }
$empleado_id = intval($_GET['empleado_id']);
$mes = sprintf('%02d', intval($_GET['mes']));
$anio = intval($_GET['anio']);
$fi = "$anio-$mes-01 00:00:00";
$ff = date('Y-m-t', strtotime($fi)).' 23:59:59';

$marcas = Marca::getByEmpleado($empleado_id,$fi,$ff);
$empleado = Empleado::findById($empleado_id);

// calculos resumidos (simplificados)
$total_seg = 0; $total_noct = 0; $llegadas_min = 0; $daily = [];
$lastEntrada = null;
foreach($marcas as $m){
    $d = date('Y-m-d', strtotime($m['fecha_hora']));
    if(!isset($daily[$d])) $daily[$d]=['entradas'=>[],'salidas'=>[]];
    if(strpos($m['tipo_marca'],'entrada')!==false){ $daily[$d]['entradas'][]=strtotime($m['fecha_hora']); $lastEntrada=strtotime($m['fecha_hora']); }
    if(strpos($m['tipo_marca'],'salida')!==false){ $daily[$d]['salidas'][]=strtotime($m['fecha_hora']); if($lastEntrada){ $seg = strtotime($m['fecha_hora'])-$lastEntrada; $total_seg += max(0,$seg); $lastEntrada=null; } }
}
$total_horas = round($total_seg/3600,2);
$pdf = new TCPDF();
$pdf->AddPage();
$pdf->SetFont('helvetica','',12);
$logo = file_get_contents(__DIR__.'/../assets/icons/logo.svg');
$pdf->writeHTMLCell(0,0,'','',$logo,0,1,false,true,'C');
$pdf->Ln(4);
$pdf->Cell(0,8,'Reporte Mensual - '.($empleado['nombre'].' '.$empleado['apellido']).'',0,1,'C');
$pdf->Ln(4);
$pdf->Cell(0,8,'Periodo: '.$mes.'-'.$anio,0,1);
$pdf->Cell(0,8,'Total Horas: '.$total_horas,0,1);
$pdf->Ln(6);
$pdf->Cell(0,8,'Detalle:',0,1);
$html = '<table border="1" cellpadding="4"><tr><th>Fecha</th><th>Tipo</th><th>Hora</th></tr>';
foreach($marcas as $m){ $html .= '<tr><td>'.date('Y-m-d',strtotime($m['fecha_hora'])).'</td><td>'.$m['tipo_marca'].'</td><td>'.date('H:i:s',strtotime($m['fecha_hora'])).'</td></tr>'; }
$html .= '</table>';
$pdf->writeHTML($html, true, false, false, false, '');
$pdf->Output('reporte.pdf','D');
?>