<?php
require_once __DIR__ . '/../models/Marca.php';
require_once __DIR__ . '/../models/Empleado.php';
header('Content-Type: application/json');
$action = $_GET['action'] ?? null;

if ($action === 'getFaces') {
    $emps = Empleado::getAll();
    $faces = array_map(function($e){ return ['id'=>$e['id'],'nombre'=>$e['nombre'].' '.$e['apellido'],'foto_base'=>null]; }, $emps);
    echo json_encode($faces); exit;
}
if ($action === 'registrar_face') {
    $data = json_decode(file_get_contents('php://input'), true);
    if (!$data) { echo json_encode(['success'=>false,'msg'=>'no data']); exit; }
    // simulate: find empleado by nombre prefix
    $nombre = $data['empleado'] ?? '';
    $emps = Empleado::getAll();
    $emp = null;
    foreach($emps as $e) if(stripos($e['nombre'],$nombre)!==false || stripos($e['apellido'],$nombre)!==false){ $emp=$e; break; }
    if(!$emp){ echo json_encode(['success'=>false,'msg'=>'empleado no encontrado']); exit; }
    $foto = $data['foto'] ?? null;
    $foto_path = null;
    if($foto){
        $bin = base64_decode(preg_replace('#^data:image/\w+;base64,#i','',$foto));
        $fname = 'marca_'.$emp['id'].'_'.time().'.jpg';
        $dir = __DIR__.'/../uploads/fotos';
        if(!is_dir($dir)) mkdir($dir,0755,true);
        file_put_contents($dir.'/'.$fname,$bin);
        $foto_path = 'uploads/fotos/'.$fname;
    }
    $record = ['empleado_id'=>$emp['id'],'tipo_marca'=>$data['tipo_marca'],'fecha_hora'=>date('Y-m-d H:i:s'),'reconocimiento_ok'=>1,'foto_captura'=>null,'foto_path'=>$foto_path];
    Marca::create($record);
    echo json_encode(['success'=>true,'foto_path'=>$foto_path]); exit;
}
echo json_encode(['success'=>false,'msg'=>'acción inválida']);
?>